<?php
/* --------------------------------------------------------------
   gm_set_session_parameters.inc.php 2019-02-22
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Session\SessionNamePostfixGenerator;
use Gambio\Core\Session\SessionRepository;
use Gambio\Core\Session\SessionService;

function gm_set_session_parameters()
{
    $host       = HTTP_SERVER;
    $webPath    = rtrim(DIR_WS_CATALOG, '/');
    $serverPath = rtrim(DIR_FS_CATALOG, '/');
    
    $url        = new Url($host, $webPath);
    $path       = new Path($serverPath);
    $repository = new SessionRepository(new SessionNamePostfixGenerator(), $path);
    
    $service = new SessionService($repository, $url, $path);
    $service->setupSession();
}
